<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#assign hasCodeList=false>
<#if sys.getAllPSCodeLists()??>
    <#list sys.getAllPSCodeLists() as codeList>
        <#if codeList.getCodeListType()=='STATIC'>
            <#assign hasCodeList=true>
            <#break >
        </#if>
    </#list>
</#if>
<#if hasCodeList>
package ${pub.getPKGCodeName()}.util.dict;

import lombok.Getter;

public class StaticDict {

    <#if sys.getAllPSCodeLists()??>
        <#list sys.getAllPSCodeLists() as codeList>
            <#assign hasCodeItem=calcHasCodeItem(codeList)>
            <#if codeList.getCodeListType()=='STATIC' && hasCodeItem>
            <#assign codeListName=codeList.codeName>
            <#comment>数值代码表int，其余为String</#comment>
            <#if codeList.isCodeItemValueNumber()>
                <#assign valueType="int">
            <#else>
                <#assign valueType="String">
            </#if>

    /**
     * 代码表[${codeList.name}]
     */
    @Getter
    public enum ${codeListName} {
            <#if codeList.getAllPSCodeItems()??>
                <#list codeList.getAllPSCodeItems() as codeItem>
                <#assign codeItemValue=codeItem.getValue()>
                <#assign codeItemText=codeItem.getText()>
        ${codeItem.codeName?upper_case}(<#if valueType=='int'>${codeItemValue}<#else>"${codeItemValue}"</#if>,"${codeItemText}")<#if codeItem_has_next>,<#else>;</#if>
                </#list>
            </#if>

        private ${valueType} value;
        private String text;
        private String valueSeparator="<#if codeList.getValueSeparator()??>${codeList.getValueSeparator()}</#if>";
        private String textSeparator="<#if codeList.getTextSeparator()??>${codeList.getTextSeparator()}</#if>";
        private String emptyText="<#if codeList.getEmptyText()?? && codeList.getEmptyText()!='未定义'>${codeList.getEmptyText()}</#if>";

        ${codeListName}(${valueType} value , String text) {
            this.value=value;
            this.text = text;
        }
    }
            </#if>

        </#list>
    </#if>
}
</#if>

<#comment>替换代码表中的特殊字符</#comment>
<#function replaceCodeItemValue codeItemValue>
    <#assign result=codeItemValue?replace("[^\\w]+","_","r")>
    <#return result>
</#function>

<#comment>判断是否含有代码项</#comment>
<#function calcHasCodeItem codeList>
    <#assign hasCodeItem=false>
    <#if codeList.getAllPSCodeItems()??>
        <#list codeList.getAllPSCodeItems() as codeItem>
            <#assign hasCodeItem=true>
            <#break>
        </#list>
    </#if>
    <#return hasCodeItem>
</#function>